/*
 * File:   convert.h
 * Author: Gernot WALZL
 */

#include <jni.h>
#include "engine.h"

#ifndef _CONVERT_H
#define	_CONVERT_H

#ifdef	__cplusplus
extern "C" {
#endif

jobject mxArray_to_jobject(JNIEnv * env, const mxArray * mxa);
mxArray * jobject_to_mxArray(JNIEnv * env, const jobject obj);

jobject mxLogicalArray_to_jbooleanmatrix(JNIEnv * env, const mxArray * mxa);
jobject mxIntegerArray_to_jintegermatrix(JNIEnv * env, const mxArray * mxa);
jobject mxDoubleArray_to_jdoublematrix(JNIEnv * env, const mxArray * mxa);
jobject mxComplexArray_to_jcomplexmatrix(JNIEnv * env, const mxArray * mxa);
jobject mxCharArray_to_jmatstring(JNIEnv * env, const mxArray * mxa);
jobject mxCellArray_to_jmatcell(JNIEnv * env, const mxArray * mxa);
jobject mxStructArray_to_jmatstruct(JNIEnv * env, const mxArray * mxa);

mxArray * jbooleanmatrix_to_mxLogicalArray(JNIEnv * env, const jobject obj);
mxArray * jintegermatrix_to_mxIntegerArray(JNIEnv * env, const jobject obj);
mxArray * jdoublematrix_to_mxDoubleArray(JNIEnv * env, const jobject obj);
mxArray * jcomplexmatrix_to_mxComplexArray(JNIEnv * env, const jobject obj);
mxArray * jmatstring_to_mxCharArray(JNIEnv * env, const jobject obj);
mxArray * jmatcell_to_mxCellArray(JNIEnv * env, const jobject obj);
mxArray * jmatstruct_to_mxStructArray(JNIEnv * env, const jobject obj);

#ifdef	__cplusplus
}
#endif

#endif	/* _CONVERT_H */
