package mat4j.types;

/**
 * @author Gernot WALZL
 */
public abstract class Matrix<T> extends MatObj {

    protected T[][] values;

    public int getNumRows() {
        if (values == null) {
            return 0;
        }
        // else
        return values.length;
    }

    public int getNumColumns() {
        if (values == null) {
            return 0;
        }
        // else
        return values[0].length;
    }

    public T getValue(int row, int column) {
        return values[row][column];
    }

    public boolean setValue(int row, int column, T value) {
        if (row >= getNumRows() || column >= getNumColumns()) {
            return false;
        }
        // else
        values[row][column] = value;
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Matrix) {
            Matrix matrix = (Matrix)obj;
            int numRows = this.getNumRows();
            int numColumns = this.getNumColumns();
            if (matrix.getNumRows() != numRows ||
                    matrix.getNumColumns() != numColumns) {
                return false;
            }
            Object value = null;
            for (int r = 0; r < numRows; r++) {
                for (int c = 0; c < numColumns; c++) {
                    value = this.getValue(r, c);
                    if (value == null) {
                        if (matrix.getValue(r, c) != null) {
                            return false;
                        }
                    } else {
                        if (!value.equals(matrix.getValue(r, c))) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.values != null ? this.values.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        int numRows = getNumRows();
        int numColumns = getNumColumns();
        String n = System.getProperty("line.separator");
        T value = null;
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int r = 0; r < numRows; r++) {
            if (r > 0) {
                result.append(";");
                result.append(n);
                result.append(" ");
            }
            result.append("[");
            for (int c = 0; c < numColumns; c++) {
                if (c > 0) {
                    result.append(", ");
                }
                value = getValue(r, c);
                if (value == null) {
                    result.append("null");
                } else {
                    result.append(value.toString());
                }
            }
            result.append("]");
        }
        result.append("]");
        return result.toString();
    }

}
