package mat4j.types;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * @author Gernot WALZL
 */
public class MatStruct extends MatObj {

    private String[] fieldnames;
    private int size;
    private HashMap<String, ArrayList<Object>> content;

    public MatStruct(String[] fieldnames, int size) {
        this.fieldnames = fieldnames;
        this.size = size;
        content = new HashMap<String, ArrayList<Object>>(fieldnames.length);
        String key = null;
        ArrayList<Object> element = null;
        for (int i = 0; i < fieldnames.length; i++) {
            if (fieldnames[i] != null) {
                key = fieldnames[i];
                element = new ArrayList<Object>(size);
                for (int j = 0; j < size; j++) {
                    element.add(null);
                }
                content.put(key, element);
            }
        }
    }

    public String[] getFieldnames() {
        return fieldnames;
    }

    public int getSize() {
        return size;
    }

    public Object getValue(String fieldname, int index) {
        return content.get(fieldname).get(index);
    }

    public boolean setValue(String fieldname, int index, Object value) {
        ArrayList<Object> element = content.get(fieldname);
        if (element == null) {
            return false;
        }
        // else
        element.set(index, value);
        return true;
    }

    public MatStruct get(int index) {
        MatStruct result = new MatStruct(fieldnames, 1);
        Object value = null;
        for (int i = 0; i < fieldnames.length; i++) {
            value = this.getValue(fieldnames[i], index);
            result.setValue(fieldnames[i], 0, value);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MatStruct) {
            MatStruct matStruct = (MatStruct)obj;
            if (size != matStruct.getSize()) {
                return false;
            }
            if (fieldnames == null || matStruct.getFieldnames() == null) {
                if (fieldnames != matStruct.getFieldnames()) {
                    return false;
                }
            } else {
                if (fieldnames.length != matStruct.getFieldnames().length) {
                    return false;
                }
                Object value = null;
                for (int i = 0; i < fieldnames.length; i++) {
                    for (int j = 0; j < size; j++) {
                        value = this.getValue(fieldnames[i], j);
                        if (value == null) {
                            if (matStruct.getValue(fieldnames[i], j) != null) {
                                return false;
                            }
                        } else {
                            if (!value.equals(
                                    matStruct.getValue(fieldnames[i], j))) {
                                return false;
                            }

                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 23 * hash +
                (this.fieldnames != null ? this.fieldnames.hashCode() : 0);
        hash = 23 * hash + this.size;
        hash = 23 * hash +
                (this.content != null ? this.content.hashCode() : 0);
        return hash;
    }

}
