package mat4j.types;

/**
 * @author Gernot WALZL
 */
public class MatString extends MatObj {

    private String str;

    public MatString(String str) {
        this.str = str;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return obj.equals(str);
        } else if (obj instanceof MatString) {
            MatString matString = (MatString)obj;
            if (str == null) {
                return (matString.toString() == null);
            } else {
                return str.equals(matString.toString());
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.str != null ? this.str.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return str;
    }

}
