package mat4j.types;

/**
 * @author Gernot WALZL
 */
public class MatCell extends MatObj {

    public int size;
    public Object[] content;

    public MatCell(int size) {
        this.size = size;
        this.content = new Object[size];
    }

    public int getSize() {
        return this.size;
    }

    public Object getValue(int index) {
        return content[index];
    }

    public boolean setValue(int index, Object value) {
        if (index >= size) {
            return false;
        }
        // else
        content[index] = value;
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MatCell) {
            MatCell matCell = (MatCell)obj;
            if (size != matCell.getSize()) {
                return false;
            }
            Object value = null;
            for (int i = 0; i < size; i++) {
                value = content[i];
                if (value == null) {
                    if (matCell.getValue(i) != null) {
                        return false;
                    }
                } else {
                    if (!value.equals(matCell.getValue(i))) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + this.size;
        hash = 71 * hash + (this.content != null ? this.content.hashCode() : 0);
        return hash;
    }

}
