package mat4j.types;

/**
 * @author Gernot WALZL
 */
public class DoubleMatrix extends Matrix<Double> {

    public DoubleMatrix(int numRows, int numColumns) {
        this.values = new Double[numRows][numColumns];
        for (int r = 0; r < numRows; r++) {
            for (int c = 0; c < numColumns; c++) {
                values[r][c] = new Double(0.0);
            }
        }
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        if (this.getNumRows() != doubleMatrix.getNumRows() ||
                this.getNumColumns() != doubleMatrix.getNumColumns()) {
            throw new RuntimeException("dimension mismatch");
        }
        int numRows = getNumRows();
        int numColumns = getNumColumns();
        DoubleMatrix result = new DoubleMatrix(numRows, numColumns);
        Double value = null;
        for (int r = 0; r < numRows; r++) {
            for (int c = 0; c < numColumns; c++) {
                value = this.getValue(r, c) + doubleMatrix.getValue(r, c);
                result.setValue(r, c, value);
            }
        }
        return result;
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        if (this.getNumColumns() != doubleMatrix.getNumRows()) {
            throw new RuntimeException("dimension mismatch");
        }
        int numRows = this.getNumRows();
        int maxIndex = this.getNumColumns();
        int numColumns = doubleMatrix.getNumColumns();
        DoubleMatrix result = new DoubleMatrix(numRows, numColumns);
        Double value = null;
        for (int r = 0; r < numRows; r++) {
            for (int c = 0; c < numColumns; c++) {
                value = 0.0;
                for (int i = 0; i < maxIndex; i++) {
                    value += this.getValue(r, i) * doubleMatrix.getValue(i, c);
                }
                result.setValue(r, c, value);
            }
        }
        return result;
    }

    public DoubleMatrix multiply(double scalar) {
        int numRows = getNumRows();
        int numColumns = getNumColumns();
        DoubleMatrix result = new DoubleMatrix(numRows, numColumns);
        Double value = null;
        for (int r = 0; r < numRows; r++) {
            for (int c = 0; c < numColumns; c++) {
                value = this.getValue(r, c) * scalar;
                result.setValue(r, c, value);
            }
        }
        return result;
    }

}
