package mat4j.types;

/**
 * @author Gernot WALZL
 */
public class ComplexMatrix extends Matrix<Complex> {

    public ComplexMatrix(int numRows, int numColumns) {
        this.values = new Complex[numRows][numColumns];
        for (int r = 0; r < numRows; r++) {
            for (int c = 0; c < numColumns; c++) {
                values[r][c] = new Complex(0.0, 0.0);
            }
        }
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        if (this.getNumRows() != complexMatrix.getNumRows() ||
                this.getNumColumns() != complexMatrix.getNumColumns()) {
            throw new RuntimeException("dimension mismatch");
        }
        int numRows = getNumRows();
        int numColumns = getNumColumns();
        ComplexMatrix result = new ComplexMatrix(numRows, numColumns);
        Complex value = null;
        for (int r = 0; r < numRows; r++) {
            for (int c = 0; c < numColumns; c++) {
                value = this.getValue(r, c).add(complexMatrix.getValue(r, c));
                result.setValue(r, c, value);
            }
        }
        return result;
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        if (this.getNumColumns() != complexMatrix.getNumRows()) {
            throw new RuntimeException("dimension mismatch");
        }
        int numRows = this.getNumRows();
        int maxIndex = this.getNumColumns();
        int numColumns = complexMatrix.getNumColumns();
        ComplexMatrix result = new ComplexMatrix(numRows, numColumns);
        Complex value = null;
        for (int r = 0; r < numRows; r++) {
            for (int c = 0; c < numColumns; c++) {
                value = new Complex(0.0, 0.0);
                for (int i = 0; i < maxIndex; i++) {
                    value = value.add(this.getValue(r, i).multiply(
                            complexMatrix.getValue(i, c)));
                }
                result.setValue(r, c, value);
            }
        }
        return result;
    }

}
