package mat4j.types;

/**
 * @author Gernot WALZL
 */
public class Complex {

    private double real;
    private double imag;

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public double getRe() {
        return real;
    }

    public void setRe(double real) {
        this.real = real;
    }

    public double getIm() {
        return imag;
    }

    public void setIm(double imag) {
        this.imag = imag;
    }

    public double getLength() {
        return Math.sqrt(imag*imag + real*real);
    }

    public double getPhi() {
        return Math.atan2(imag, real);
    }

    public Complex conjugate() {
        return new Complex(real, -imag);
    }

    public Complex add(Complex complex) {
        double resReal = this.real + complex.getRe();
        double resImag = this.imag + complex.getIm();
        return new Complex(resReal, resImag);
    }

    public Complex multiply(Complex complex) {
        double resReal = (this.real * complex.getRe())
                - (this.imag * complex.getIm());
        double resImag = (this.real * complex.getIm())
                + (this.imag * complex.getRe());
        return new Complex(resReal, resImag);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Complex) {
            Complex complex = (Complex)obj;
            if (complex.getRe() == this.getRe() &&
                    complex.getIm() == this.getIm()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (int) (Double.doubleToLongBits(this.real)
                ^ (Double.doubleToLongBits(this.real) >>> 32));
        hash = 31 * hash + (int) (Double.doubleToLongBits(this.imag)
                ^ (Double.doubleToLongBits(this.imag) >>> 32));
        return hash;
    }

    @Override
    public String toString() {
        return real + " + " + imag + "i";
    }

}
