package mat4j.engines;

import mat4j.types.MatObj;

/**
 * @author Gernot WALZL
 */
public abstract class MatEngine {

    public abstract boolean open(String arguments);
    public abstract void close();
    public abstract boolean eval(String command);
    public abstract String getOutput();
    public abstract MatObj getVariable(String name);
    public abstract boolean putVariable(String name, MatObj value);

}
