package mat4j;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import mat4j.engines.MatlabEngine;
import mat4j.types.MatObj;

/**
 * @author Gernot WALZL
 */
public class Main {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        String command = "";
        String varname = "";
        String output = "";
        MatObj variable = null;
        BufferedImage image = null;
        MatlabEngine matlabEngine = new MatlabEngine();
        matlabEngine.open(null);
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        try {
            System.out.println();
            System.out.println("Mat4J - MATLAB Engine for Java");
            System.out.println("http://mat4j.sourceforge.net/");
            System.out.println();
            while (!(command.equals("exit") || command.equals("quit"))) {
                output = matlabEngine.getOutput();
                System.out.print(output);
                System.out.print(">> ");
                command = br.readLine();
                if (command.startsWith("get ")) {
                    varname = command.substring(4, command.length()).trim();
                    variable = matlabEngine.getVariable(varname);
                    if (variable == null) {
                        System.out.println("Variable '"+varname+"' not found.");
                    } else {
                        System.out.println(variable.toString());
                    }
                } else if (command.startsWith("getImage ")) {
                    varname = command.substring(9, command.length()).trim();
                    image = matlabEngine.getImage(varname);
                    if (image == null) {
                        System.out.println("Handle '"+varname+"' not found.");
                    } else {
                        new ImageFrame(varname, image);
                    }
                } else {
                    matlabEngine.eval(command);
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        matlabEngine.close();
    }

}
