package mat4j;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;

/**
 * @author Gernot WALZL
 */
public class ImageFrame extends Frame {

    private BufferedImage image;

    public ImageFrame(String title, BufferedImage image) {
        super(title);
        this.image = image;
        setSize(image.getWidth(), image.getHeight());
        setVisible(true);
        addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent we) {
                dispose();
            }
        });
    }

    @Override
    public void update(Graphics g) {
        paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (image != null) {
            g.drawImage(image, 0, 0, this);
        } else {
            g.clearRect(0, 0, getWidth(), getHeight());
        }
    }

}
