#include "simple_replacer.hpp"
#include <boost/algorithm/string.hpp>

namespace util {

SimpleReplacer::SimpleReplacer(const std::string& content)
    : content_(content)
{
}

SimpleReplacer::~SimpleReplacer() = default;

void SimpleReplacer::replaceAll(const std::string& search,
    const std::string& replace)
{
    boost::replace_all(content_, search, replace);
}

std::string SimpleReplacer::getContent() const
{
    return content_;
}

} // namespace util
