from conan import ConanFile
from conan.errors import ConanException
from conan.tools.cmake import CMakeToolchain, CMake, cmake_layout, CMakeDeps
from conan.tools.scm import Git
from conan.tools.files import update_conandata


class HelloWorldRecipe(ConanFile):
    name = "helloworld"
    package_type = "application"
    settings = "os", "compiler", "build_type", "arch"

    def export(self):
        git = Git(self, self.recipe_folder)
        scm_url, scm_commit = git.get_url_and_commit()
        self.output.info(f"Obtained URL: {scm_url} and {scm_commit}")
        update_conandata(self, {
            "sources": {"commit": scm_commit, "url": scm_url}
        })

    def source(self):
        git = Git(self)
        sources = self.conan_data["sources"]
        self.output.info(f"Cloning sources from: {sources}")
        git.clone(url=sources["url"], target=".")
        git.checkout(commit=sources["commit"])

    def set_version(self):
        try:
            git = Git(self, self.recipe_folder)
            self.version = git.run("describe --tags")
            if self.version[0] == "v":
                self.version = self.version[1:]
        except ConanException as exc:
            self.output.warning(f"Exception in set_version: {exc}")
            self.version = "undef"

    def requirements(self):
        self.requires("boost/1.81.0")

    def layout(self):
        cmake_layout(self)

    def generate(self):
        deps = CMakeDeps(self)
        deps.generate()
        tc = CMakeToolchain(self)
        tc.generate()

    def build(self):
        cmake = CMake(self)
        cmake.configure()
        cmake.build()

    def package(self):
        cmake = CMake(self)
        cmake.install()
