/*
 * SOMTreeClassifierNodeTest.java
 * JUnit based test
 *
 * Created on 2007-10-10, 10:58
 */

package iaik.som;

import junit.framework.*;

/**
 * JUnit based test for SOMTreeClassifierNode.
 *
 * @author Gernot WALZL
 */
public class SOMTreeClassifierNodeTest extends TestCase {

    public SOMTreeClassifierNodeTest(String testName) {
        super(testName);
    }

    public void testGenerateErrorMatrix() {
        System.out.println("generateErrorMatrix");

        double[][] relativeError = {{0.0, 0.0, 0.0},
                {0.1, 0.0, 0.2},
                {0.02, 0.0, 0.0}};
        double errorThreshold = 0.05;

        boolean[][] expected = {{false, true, false},
                {true, false, true},
                {false, true, false}};
        boolean[][] result = SOMTreeClassifierNode.generateErrorMatrix(
                relativeError, errorThreshold);
        assertTrue(MyMath.equalMatrix(expected, result));
    }

    public void testGenerateMergeLists() {
        System.out.println("generateMergeLists");

        boolean[][] errorMatrix1 = {{false, true, false},
                {true, false, false},
                {false, false, false}};

        boolean[][] expected1 = {{true, true, false}};
        boolean[][] result1 = SOMTreeClassifierNode.generateMergeLists(
                errorMatrix1);
        assertTrue(MyMath.equalMatrix(expected1, result1));

        boolean[][] errorMatrix2 = {{false, true, false, false},
                {true, false, false, false},
                {false, false, false, true},
                {false, false, true, false}};

        boolean[][] expected2 = {{true, true, false, false},
                {false, false, true, true}};
        boolean[][] result2 = SOMTreeClassifierNode.generateMergeLists(
                errorMatrix2);
        assertTrue(MyMath.equalMatrix(expected2, result2));
    }

    public void testFilterTrainingData() {
        System.out.println("filterTrainingData");

        double[][] trainingData = {{0.7036, 0.1400},
                {0.4850, 0.5668},
                {0.1146, 0.8230},
                {0.6649, 0.6739},
                {0.3654, 0.9994},
                {1.1111, 1.1111},
                {1.2222, 1.2222}};
        int[] trainingClasses = {0, 1, 1, 0, 1, 2, 2};
        boolean[] mergeList = {true, true, false};

        double[][] expected = {{0.7036, 0.1400},
                {0.4850, 0.5668},
                {0.1146, 0.8230},
                {0.6649, 0.6739},
                {0.3654, 0.9994}};
        double[][] result = SOMTreeClassifierNode.filterTrainingData(
                trainingData, trainingClasses, mergeList);
        assertTrue(MyMath.equalMatrix(expected, result, 3));
    }

    public void testFilterTrainingClasses() {
        System.out.println("filterTrainingClasses");

        int[] trainingClasses = {0, 1, 1, 0, 1, 2, 2};
        boolean[] mergeList = {true, true, false};

        int[] expected = {0, 1, 1, 0, 1};
        int[] result = SOMTreeClassifierNode.filterTrainingClasses(
                trainingClasses, mergeList);
        assertTrue(MyMath.equalVector(expected, result));
    }

    public void testFilterLabels() {
        System.out.println("filterLabels");

        Object[] labels = {0, 1, 2};
        boolean[] mergeList = {true, true, false};

        Object[] expected = {0, 1};
        Object[] result = SOMTreeClassifierNode.filterLabels(labels, mergeList);
        for (int i = 0; i < expected.length; i++)
            assertEquals(expected[i], result[i]);
    }

}
