/*
 * SOMClassifierTest.java
 * JUnit based test
 *
 * Created on 2007-06-05, 19:14
 */

package iaik.som;

import junit.framework.*;

/**
 * JUnit based test for SOMClassifier.
 *
 * @author Gernot WALZL
 */
public class SOMClassifierTest extends TestCase {

    public SOMClassifierTest(String testName) {
        super(testName);
    }

    public void testClassificationProb() {
        System.out.println("classificationProb");

        double[][] trainingData = {{0.7036, 0.1400},
                {0.4850, 0.5668},
                {0.1146, 0.8230},
                {0.6649, 0.6739},
                {0.3654, 0.9994}};
        int[] classes = {0, 1, 1, 0, 1};

        SOMClassifier classifier = new SOMClassifier(trainingData, classes);
        double[][] testData = trainingData;
        double[][] result = classifier.classificationProbability(testData);

        double[][] expected = {{1.0, 0.0},
                {0.0, 1.0},
                {0.0, 1.0},
                {1.0, 0.0},
                {0.0, 1.0}};

        assertTrue(MyMath.equalMatrix(expected, result, 3));
    }

    public void testClassify() {
        System.out.println("classify");

        double[][] trainingData = {{0.7036, 0.1400},
                {0.4850, 0.5668},
                {0.1146, 0.8230},
                {0.6649, 0.6739},
                {0.3654, 0.9994}};
        int[] classes = {0, 1, 1, 0, 1};

        SOMClassifier classifier = new SOMClassifier(trainingData, classes);

        double[][] testData = trainingData;
        int[] expected = {0, 1, 1, 0, 1};
        int[] result = classifier.classify(testData);

        assertTrue(MyMath.equalVector(expected, result));
    }


    public void testClassifyLabeled() {
        System.out.println("classifyLabeled");

        double[][] trainingData = {{0.7036, 0.1400},
                {0.4850, 0.5668},
                {0.1146, 0.8230},
                {0.6649, 0.6739},
                {0.3654, 0.9994}};
        int[] classes = {0, 1, 1, 0, 1};
        Object[] labels = {"A", "B"};
        SOMClassifier classifier = new SOMClassifier(trainingData, classes);
        classifier.setLabels(labels);

        double[][] testData = trainingData;
        Object[] expected = {"A", "B", "B", "A", "B"};
        Object[] result = classifier.classifyLabeled(testData);

        for (int i = 0; i < expected.length; i++)
            assertEquals(expected[i], result[i]);
    }


    public void testCountClassifications() {
        System.out.println("countClassifications");

        double[][] trainingData = {{0.7036, 0.1400},
                {0.4850, 0.5668},
                {0.1146, 0.8230},
                {0.6649, 0.6739},
                {0.3654, 0.9994}};
        int[] classes = {0, 1, 1, 0, 1};

        SOMClassifier classifier = new SOMClassifier(trainingData, classes);

        double[][] testData = trainingData;
        int[] testClasses = {1, 1, 1, 1, 1};

        int[][] expected = {{0, 0},
                {2, 3}};
        int[][] result = classifier.countClassifications(testData, testClasses);

        assertTrue(MyMath.equalMatrix(expected, result));
    }


    public void testCalculateRelativeError() {
        System.out.println("calculateRelativeError");

        double[][] trainingData = {{0.7036, 0.1400},
                {0.4850, 0.5668},
                {0.1146, 0.8230},
                {0.6649, 0.6739},
                {0.3654, 0.9994}};
        int[] classes = {0, 1, 1, 0, 1};

        SOMClassifier classifier = new SOMClassifier(trainingData, classes);

        double[][] testData = trainingData;
        int[] testClasses = {1, 1, 1, 1, 1};

        double[][] expected = {{0.0, 0.0},
                {0.4, 0.0}};
        double[][] result = classifier.calculateRelativeError(testData,
                testClasses);

        assertTrue(MyMath.equalMatrix(expected, result, 2));
    }


    public void testFromToString() {
        System.out.println("toString");

        double[][] trainingData = {{0.7036, 0.1400},
                {0.4850, 0.5668},
                {0.1146, 0.8230},
                {0.6649, 0.6739},
                {0.3654, 0.9994}};
        int[] classes = {0, 1, 1, 0, 1};

        SOMClassifier classifier = new SOMClassifier(trainingData, classes);
        String content = classifier.toString();
        SOMClassifier result = new SOMClassifier(content);

        assertEquals(content, result.toString());
    }


    public void testSpeed() {
        System.out.println("speed");
        String strTrainingData = "[[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.4, 8.5];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.4, 8.5];"
            + "[1.0, 1.0, 1.1, 1.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.3, 1.7];"
            + "[1.0, 1.0, 1.4, 3.1];"
            + "[1.0, 1.0, 1.4, 2.9];"
            + "[1.0, 1.0, 1.3, 1.8];"
            + "[1.0, 1.0, 1.3, 1.8];"
            + "[1.0, 1.0, 1.3, 1.9];"
            + "[1.0, 1.0, 1.2, 1.5];"
            + "[1.0, 1.0, 1.3, 1.8];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.1, 1.1];"
            + "[1.0, 1.0, 1.2, 1.5];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.2, 1.5];"
            + "[2.0, 1.0, 2.2, 7.6];"
            + "[2.0, 1.0, 2.3, 6.4];"
            + "[2.0, 1.0, 2.3, 9.9];"
            + "[1.0, 1.0, 1.3, 1.4];"
            + "[2.0, 1.0, 2.2, 7.6];"
            + "[2.0, 1.0, 2.3, 6.4];"
            + "[2.0, 1.0, 2.3, 9.9];"
            + "[2.0, 1.0, 2.2, 6.5];"
            + "[2.0, 1.0, 2.3, 5.8];"
            + "[2.0, 1.0, 2.2, 15.8];"
            + "[2.0, 1.0, 2.2, 16.2];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.4, 8.7];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.6, 8.9];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.5, 8.6];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.6, 9.5];"
            + "[1.0, 1.0, 1.6, 9.0];"
            + "[1.0, 1.0, 1.6, 9.5];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.4, 9.4];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.4, 9.3];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.4, 9.7];"
            + "[1.0, 1.0, 1.6, 9.5];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.2, 2.1];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.6, 9.2];"
            + "[1.0, 1.0, 1.2, 2.2];"
            + "[1.0, 1.0, 1.2, 1.8];"
            + "[1.0, 1.0, 1.4, 3.3];"
            + "[1.0, 1.0, 1.3, 1.9];"
            + "[1.0, 1.0, 1.3, 1.8];"
            + "[1.0, 1.0, 1.2, 2.0];"
            + "[1.0, 1.0, 1.5, 1.6];"
            + "[1.0, 1.0, 1.1, 0.7];"
            + "[2.0, 1.0, 2.7, 2.1];"
            + "[2.0, 1.0, 2.4, 2.6];"
            + "[22.0, 1.0, 11.9, 4.3];"
            + "[74.0, 2.0, 25.0, 58.9];"
            + "[5.0, 1.0, 4.8, 3.1];"
            + "[19.0, 2.0, 8.4, 1.3];"
            + "[21.0, 1.0, 14.5, 0.9];"
            + "[10.0, 1.0, 8.6, 4.0];"
            + "[10.0, 1.0, 10.7, 2.8];"
            + "[17.0, 1.0, 14.2, 3.2];"
            + "[17.0, 1.0, 14.6, 2.6];"
            + "[21.0, 1.0, 14.5, 0.9];"
            + "[9.0, 1.0, 9.7, 4.0];"
            + "[10.0, 1.0, 8.3, 3.7];"
            + "[73.0, 2.0, 24.7, 132.5];"
            + "[5.0, 1.0, 5.7, 2.7];"
            + "[10.0, 1.0, 8.8, 3.9];"
            + "[12.0, 1.0, 10.4, 2.6];"
            + "[11.0, 1.0, 7.6, 1.3];"
            + "[24.0, 1.0, 13.4, 1.7];"
            + "[6.0, 1.0, 6.1, 3.5];"
            + "[17.0, 1.0, 14.2, 3.2];"
            + "[11.0, 1.0, 11.6, 0.9];"
            + "[71.0, 2.0, 24.0, 289.4];"
            + "[16.0, 1.0, 13.5, 3.9];"
            + "[4.0, 1.0, 3.7, 3.3];"
            + "[3.0, 1.0, 3.2, 2.9];"
            + "[2.0, 1.0, 1.4, 279.0];"
            + "[7.0, 1.0, 6.2, 2.1];"
            + "[4.0, 1.0, 3.6, 3.1];"
            + "[2.0, 1.0, 2.9, 3.1];"
            + "[1.0, 1.0, 1.9, 20.9];"
            + "[9.0, 1.0, 7.5, 4.2];"
            + "[4.0, 1.0, 2.9, 3.0];"
            + "[6.0, 1.0, 4.4, 3.3];"
            + "[10.0, 2.0, 4.6, 3.4];"
            + "[8.0, 1.0, 6.7, 3.5];"
            + "[13.0, 1.0, 9.1, 2.6];"
            + "[17.0, 1.0, 14.4, 2.5];"
            + "[16.0, 1.0, 11.2, 5.0];"
            + "[16.0, 1.0, 10.7, 5.0];"
            + "[8.0, 1.0, 8.8, 4.2];"
            + "[11.0, 1.0, 7.9, 3.8];"
            + "[7.0, 1.0, 6.5, 3.2];"
            + "[16.0, 1.0, 11.3, 2.4];"
            + "[3.0, 1.0, 3.5, 3.2];"
            + "[3.0, 1.0, 3.3, 3.0];"
            + "[2.0, 1.0, 2.1, 3.9];"
            + "[3.0, 1.0, 2.4, 2.9];"
            + "[3.0, 1.0, 3.9, 3.2];"
            + "[2.0, 1.0, 1.7, 3.3];"
            + "[4.0, 1.0, 3.6, 3.1];"
            + "[2.0, 1.0, 2.8, 2.9];"
            + "[2.0, 1.0, 1.7, 245.4];"
            + "[4.0, 1.0, 4.0, 3.5];"
            + "[4.0, 1.0, 4.0, 3.5];"
            + "[2.0, 1.0, 2.7, 2.9];"
            + "[1.0, 1.0, 1.3, 1.4];"
            + "[15.0, 2.0, 6.6, 2.1];"
            + "[35.0, 1.0, 24.0, 170.6];"
            + "[10.0, 1.0, 5.9, 3.1];"
            + "[45.0, 1.0, 24.4, 159.2];"
            + "[11.0, 1.0, 6.4, 1.4];"
            + "[9.0, 1.0, 7.5, 6.7];"
            + "[8.0, 1.0, 6.8, 5.5];"
            + "[36.0, 1.0, 24.3, 189.7];"
            + "[15.0, 1.0, 12.5, 4.8];"
            + "[23.0, 1.0, 12.7, 2.7];"
            + "[12.0, 1.0, 8.3, 5.6];"
            + "[12.0, 2.0, 5.4, 2.3];"
            + "[17.0, 1.0, 11.9, 4.0];"
            + "[6.0, 1.0, 4.9, 2.9];"
            + "[3.0, 1.0, 3.6, 2.7];"
            + "[3.0, 1.0, 2.9, 3.1];"
            + "[18.0, 1.0, 12.4, 3.7];"
            + "[11.0, 1.0, 9.5, 2.3];"
            + "[8.0, 1.0, 6.8, 2.9];"
            + "[18.0, 1.0, 14.8, 65.8];"
            + "[9.0, 1.0, 7.4, 2.6];"
            + "[45.0, 1.0, 24.4, 182.5];"
            + "[21.0, 2.0, 9.0, 1.7];"
            + "[15.0, 1.0, 12.8, 3.9];"
            + "[8.0, 1.0, 7.3, 2.1];"
            + "[10.0, 1.0, 8.5, 3.9];"
            + "[3.0, 1.0, 3.1, 3.6];"
            + "[9.0, 1.0, 7.5, 6.7];"
            + "[23.0, 1.0, 12.8, 12.0];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[20.0, 2.0, 8.6, 2.9];"
            + "[23.0, 1.0, 23.9, 208.6];"
            + "[23.0, 2.0, 10.2, 3.6];"
            + "[10.0, 1.0, 8.8, 5.4];"
            + "[2.0, 1.0, 2.6, 2.9];"
            + "[33.0, 1.0, 27.1, 164.9];"
            + "[25.0, 1.0, 26.0, 230.6];"
            + "[39.0, 1.0, 26.3, 212.9];"
            + "[39.0, 1.0, 26.3, 212.9];"
            + "[39.0, 1.0, 26.3, 212.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[31.0, 1.0, 26.2, 221.3];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[79.0, 2.0, 26.7, 192.5];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[47.0, 1.0, 25.7, 239.9];"
            + "[61.0, 2.0, 26.6, 198.6];"
            + "[49.0, 1.0, 26.5, 205.4];"
            + "[60.0, 2.0, 25.9, 232.9];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[24.0, 1.0, 24.8, 119.6];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[24.0, 1.0, 24.1, 102.0];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[13.0, 1.0, 11.3, 42.4];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[13.0, 1.0, 11.3, 42.4];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[13.0, 1.0, 11.3, 42.4];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[20.0, 1.0, 20.7, 164.4];"
            + "[13.0, 1.0, 11.3, 42.4];"
            + "[29.0, 1.0, 19.7, 151.1];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[17.0, 1.0, 17.7, 185.4];"
            + "[1.0, 1.0, 1.5, 2.5];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[5.0, 1.0, 5.8, 2.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[22.0, 1.0, 22.2, 161.0];"
            + "[10.0, 1.0, 10.3, 43.7];"
            + "[1.0, 1.0, 1.5, 12.0];"
            + "[1.0, 1.0, 1.3, 7.3];"
            + "[21.0, 1.0, 14.5, 696.1];"
            + "[3.0, 1.0, 3.3, 73.4];"
            + "[1.0, 1.0, 1.1, 3.7];"
            + "[1.0, 1.0, 1.3, 7.4];"
            + "[65.0, 2.0, 21.9, 568.5];"
            + "[95.0, 3.0, 23.9, 332.0];"
            + "[1.0, 1.0, 1.2, 8.7];"
            + "[1.0, 1.0, 1.2, 7.5];"
            + "[1.0, 1.0, 1.5, 12.0];"
            + "[1.0, 1.0, 1.3, 7.3];"
            + "[21.0, 1.0, 14.5, 696.1];"
            + "[6.0, 1.0, 4.3, 78.6];"
            + "[1.0, 1.0, 1.1, 3.7];"
            + "[1.0, 1.0, 1.1, 3.3];"
            + "[1.0, 1.0, 1.3, 10.8];"
            + "[31.0, 1.0, 21.3, 767.2];"
            + "[48.0, 2.0, 21.0, 626.1];"
            + "[54.0, 2.0, 23.5, 384.9];"
            + "[35.0, 1.0, 23.5, 360.8];"
            + "[17.0, 1.0, 17.8, 731.4];"
            + "[55.0, 2.0, 23.7, 347.7];"
            + "[30.0, 1.0, 20.2, 803.9];"
            + "[123.0, 4.0, 21.9, 414.0];"
            + "[1.0, 1.0, 1.2, 8.7];"
            + "[1.0, 1.0, 1.2, 8.1];"
            + "[71.0, 2.0, 24.1, 270.9];"
            + "[471.0, 10.0, 25.2, 0.0];"
            + "[135.0, 4.0, 24.0, 316.3];"
            + "[28.0, 1.0, 23.1, 427.2];"
            + "[1.0, 1.0, 1.2, 8.7];"
            + "[1.0, 1.0, 1.3, 8.9];"
            + "[43.0, 1.0, 23.4, 390.5];"
            + "[42.0, 2.0, 18.3, 642.2];"
            + "[72.0, 2.0, 24.1, 263.4];"
            + "[1.0, 1.0, 1.2, 8.7];"
            + "[1.0, 1.0, 1.2, 8.7];"
            + "[1.0, 1.0, 1.2, 8.9];"
            + "[27.0, 1.0, 18.6, 900.8];"
            + "[1.0, 1.0, 1.2, 8.7];"
            + "[1.0, 1.0, 1.1, 3.5];"
            + "[6.0, 1.0, 4.1, 106.1];"
            + "[3.0, 1.0, 3.3, 108.3];"
            + "[1.0, 1.0, 1.2, 6.8];"
            + "[71.0, 2.0, 24.0, 277.0];"
            + "[71.0, 2.0, 24.0, 279.9];"
            + "[43.0, 1.0, 23.6, 361.7];"
            + "[35.0, 1.0, 23.6, 336.0];"
            + "[73.0, 2.0, 24.6, 41.1];"
            + "[23.0, 1.0, 23.0, 71.1];"
            + "[55.0, 2.0, 24.0, 55.6];"
            + "[13.0, 1.0, 13.2, 44.5];"
            + "[1.0, 1.0, 1.2, 5.1];"
            + "[1.0, 1.0, 1.2, 5.1];"
            + "[1.0, 1.0, 1.2, 10.1];"
            + "[1.0, 1.0, 1.2, 2.0];"
            + "[1.0, 1.0, 1.2, 10.1];"
            + "[1.0, 1.0, 1.3, 13.5];"
            + "[1.0, 1.0, 1.2, 10.1];"
            + "[1.0, 1.0, 1.2, 10.1];"
            + "[1.0, 1.0, 1.2, 10.1];"
            + "[1.0, 1.0, 1.3, 13.5];"
            + "[1.0, 1.0, 1.2, 10.1];"
            + "[4.0, 1.0, 3.5, 439.1];"
            + "[43.0, 1.0, 23.7, 72.8];"
            + "[17.0, 1.0, 14.3, 43.6];"
            + "[1.0, 1.0, 1.1, 0.9];"
            + "[1.0, 1.0, 1.2, 1.0];"
            + "[1.0, 1.0, 1.2, 0.7];"
            + "[1.0, 1.0, 1.2, 1.5];"
            + "[1.0, 1.0, 1.6, 18.8];"
            + "[3.0, 1.0, 3.5, 35.3];"
            + "[73.0, 2.0, 24.6, 41.1];"
            + "[1.0, 1.0, 1.1, 1.4];"
            + "[1.0, 1.0, 1.1, 0.9];"
            + "[1.0, 1.0, 1.2, 1.0];"
            + "[7.0, 1.0, 5.3, 598.0];"
            + "[42.0, 1.0, 23.1, 105.1];"
            + "[1.0, 1.0, 1.1, 1.3];"
            + "[1.0, 1.0, 1.1, 0.6];"
            + "[18.0, 1.0, 10.2, 31.8];"
            + "[17.0, 1.0, 17.2, 30.3];"
            + "[1.0, 1.0, 1.1, 15.2];"
            + "[1.0, 1.0, 1.1, 0.6];"
            + "[3.0, 1.0, 3.3, 57.3];"
            + "[7.0, 1.0, 6.0, 39.6];"
            + "[3.0, 1.0, 3.2, 34.2];"
            + "[12.0, 1.0, 8.7, 57.5];"
            + "[17.0, 1.0, 14.0, 38.2];"
            + "[1.0, 1.0, 1.6, 16.4];"
            + "[49.0, 2.0, 21.3, 36.9];"
            + "[1.0, 1.0, 1.0, 5.1];"
            + "[1.0, 1.0, 1.1, 7.7];"
            + "[1.0, 1.0, 1.0, 6.7];"
            + "[3.0, 1.0, 2.7, 398.6];"
            + "[7.0, 1.0, 6.3, 31.3];"
            + "[9.0, 1.0, 6.3, 76.9];"
            + "[13.0, 1.0, 13.1, 32.6];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.7, 114.9];"
            + "[34.0, 1.0, 18.5, 39.8];"
            + "[13.0, 1.0, 10.7, 34.9];"
            + "[20.0, 1.0, 13.7, 46.1];"
            + "[55.0, 2.0, 24.0, 36.8];"
            + "[1.0, 1.0, 1.1, 0.9];"
            + "[3.0, 1.0, 3.3, 30.1];"
            + "[21.0, 2.0, 9.1, 75.3];"
            + "[1.0, 1.0, 1.1, 2.0];"
            + "[1.0, 1.0, 1.2, 1.5];"
            + "[3.0, 1.0, 3.9, 397.8];"
            + "[1.0, 1.0, 1.6, 85.6];"
            + "[30.0, 2.0, 13.2, 44.5];"
            + "[1.0, 1.0, 1.2, 3.0];"
            + "[1.0, 1.0, 1.2, 1.0];"
            + "[2.0, 1.0, 2.6, 28.0];"
            + "[57.0, 2.0, 24.7, 46.6];"
            + "[4.0, 1.0, 4.2, 17.2];"
            + "[4.0, 1.0, 4.7, 19.1];"
            + "[11.0, 1.0, 9.5, 22.3];"
            + "[50.0, 1.0, 27.1, 190.0];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[46.0, 1.0, 25.0, 398.8];"
            + "[25.0, 1.0, 25.5, 88.5];"
            + "[26.0, 1.0, 26.1, 335.8];"
            + "[32.0, 1.0, 26.2, 320.2];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[48.0, 1.0, 26.4, 312.3];"
            + "[58.0, 2.0, 25.2, 385.7];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 307.9];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[58.0, 2.0, 25.2, 385.7];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[58.0, 2.0, 25.2, 387.8];"
            + "[21.0, 1.0, 21.3, 335.8];"
            + "[25.0, 1.0, 25.5, 88.5];"
            + "[39.0, 1.0, 26.4, 306.6];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[58.0, 2.0, 25.2, 385.7];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[58.0, 2.0, 25.2, 385.7];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[58.0, 2.0, 25.2, 385.7];"
            + "[21.0, 1.0, 21.3, 335.8];"
            + "[25.0, 1.0, 25.5, 88.5];"
            + "[39.0, 1.0, 26.4, 306.6];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[58.0, 2.0, 25.2, 395.6];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[58.0, 2.0, 25.2, 385.7];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 305.6];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[46.0, 1.0, 25.0, 398.8];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[47.0, 1.0, 25.5, 337.9];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[46.0, 1.0, 25.0, 398.8];"
            + "[61.0, 2.0, 26.6, 289.7];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[46.0, 1.0, 25.0, 398.8];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[22.0, 1.0, 22.1, 72.3];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 288.1];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[46.0, 1.0, 25.0, 398.8];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[49.0, 1.0, 26.5, 294.5];"
            + "[61.0, 2.0, 26.6, 283.8];"
            + "[22.0, 1.0, 22.1, 72.3];"
            + "[3.0, 1.0, 3.4, 9.8];"
            + "[3.0, 1.0, 3.1, 6.1];"
            + "[3.0, 1.0, 3.6, 9.7];"
            + "[5.0, 1.0, 5.6, 16.6];"
            + "[4.0, 1.0, 3.7, 9.0];"
            + "[4.0, 1.0, 4.1, 11.1];"
            + "[7.0, 1.0, 7.8, 24.4];"
            + "[1.0, 1.0, 0.8, 24.9];"
            + "[1.0, 1.0, 0.9, 23.6];"
            + "[1.0, 1.0, 0.9, 19.4];"
            + "[1.0, 1.0, 0.6, 0.6];"
            + "[6.0, 1.0, 5.0, 19.6];"
            + "[1.0, 2.0, 0.5, 0.5];"
            + "[1.0, 1.0, 0.9, 19.4];"
            + "[1.0, 1.0, 0.8, 24.3];"
            + "[3.0, 1.0, 3.0, 6.0];"
            + "[1.0, 1.0, 1.3, 40.8];"
            + "[1.0, 1.0, 1.5, 0.7];"
            + "[1.0, 1.0, 0.6, 0.8];"
            + "[2.0, 1.0, 2.6, 6.6];"
            + "[1.0, 1.0, 0.7, 1.0];"
            + "[1.0, 1.0, 0.7, 1.0];"
            + "[4.0, 1.0, 4.7, 11.0];"
            + "[3.0, 1.0, 3.6, 11.9];"
            + "[5.0, 1.0, 5.1, 21.6];"
            + "[4.0, 1.0, 5.0, 13.4];"
            + "[3.0, 1.0, 3.7, 9.9];"
            + "[3.0, 1.0, 3.0, 6.0];"
            + "[3.0, 1.0, 2.5, 6.2];"
            + "[5.0, 1.0, 5.6, 15.5];"
            + "[3.0, 1.0, 3.5, 8.3];"
            + "[3.0, 1.0, 2.9, 11.4];"
            + "[6.0, 1.0, 5.0, 13.6];"
            + "[3.0, 1.0, 3.0, 6.0];"
            + "[4.0, 1.0, 5.0, 13.4];"
            + "[5.0, 1.0, 5.1, 21.6];"
            + "[10.0, 1.0, 7.1, 20.4];"
            + "[1.0, 1.0, 0.7, 0.4];"
            + "[4.0, 1.0, 3.5, 9.6];"
            + "[4.0, 1.0, 4.8, 16.7];"
            + "[6.0, 1.0, 5.1, 16.2];"
            + "[4.0, 1.0, 4.3, 13.2];"
            + "[5.0, 1.0, 4.0, 11.1];"
            + "[5.0, 1.0, 5.7, 21.2];"
            + "[5.0, 1.0, 4.2, 9.7];"
            + "[4.0, 1.0, 3.7, 11.3];"
            + "[4.0, 1.0, 4.0, 6.3];"
            + "[3.0, 1.0, 3.3, 13.4];"
            + "[6.0, 1.0, 5.1, 16.7];"
            + "[5.0, 1.0, 5.1, 15.9];"
            + "[14.0, 1.0, 14.3, 26.5];"
            + "[6.0, 1.0, 6.4, 21.4];"
            + "[12.0, 1.0, 12.6, 26.2];"
            + "[8.0, 1.0, 8.2, 25.6];"
            + "[9.0, 1.0, 9.1, 21.7];"
            + "[5.0, 1.0, 4.2, 15.8];"
            + "[7.0, 1.0, 6.5, 21.6];"
            + "[7.0, 1.0, 7.2, 25.9];"
            + "[12.0, 1.0, 8.4, 24.5];"
            + "[5.0, 1.0, 5.5, 16.1];"
            + "[4.0, 1.0, 4.4, 15.5];"
            + "[9.0, 1.0, 8.2, 24.3];"
            + "[1.0, 2.0, 0.6, 0.9];"
            + "[4.0, 1.0, 3.6, 8.0];"
            + "[7.0, 1.0, 6.2, 22.8];"
            + "[1.0, 1.0, 0.9, 0.9];"
            + "[18.0, 1.0, 12.6, 250.3];"
            + "[68.0, 2.0, 22.9, 467.3];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.4];"
            + "[1.0, 1.0, 1.0, 0.8];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[4.0, 1.0, 3.9, 97.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.4];"
            + "[1.0, 1.0, 1.0, 0.8];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.8];"
            + "[1.0, 1.0, 1.0, 0.7];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.4];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 0.8];"
            + "[1.0, 1.0, 1.0, 0.7];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 0.7];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.5];"
            + "[1.0, 1.0, 1.0, 0.8];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.8];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[36.0, 2.0, 15.6, 208.7];"
            + "[19.0, 1.0, 15.9, 226.6];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.1, 0.8];"
            + "[1.0, 1.0, 1.0, 1.4];"
            + "[1.0, 1.0, 1.3, 9.7];"
            + "[2.0, 2.0, 1.0, 2.0];"
            + "[1.0, 1.0, 0.9, 0.0];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[3.0, 1.0, 3.7, 126.3];"
            + "[1.0, 1.0, 1.0, 1.2];"
            + "[1.0, 1.0, 1.0, 0.8];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 0.9, 0.2];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.1, 1.9];"
            + "[1.0, 1.0, 1.1, 3.7];"
            + "[1.0, 1.0, 1.1, 0.7];"
            + "[1.0, 1.0, 1.0, 0.7];"
            + "[4.0, 1.0, 4.7, 126.5];"
            + "[1.0, 1.0, 1.0, 1.1];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[1.0, 1.0, 1.0, 1.4];"
            + "[1.0, 1.0, 1.0, 0.8];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.3];"
            + "[1.0, 1.0, 1.0, 0.9];"
            + "[1.0, 1.0, 1.0, 1.0];"
            + "[26.0, 1.0, 14.4, 138.4];"
            + "[5.0, 1.0, 4.9, 93.5];"
            + "[4.0, 1.0, 4.9, 69.9];"
            + "[1.0, 1.0, 1.1, 0.8];"
            + "[1.0, 1.0, 0.7, 0.0];"
            + "[5.0, 1.0, 4.4, 95.9]]";
        String strClasses = "[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "
                + "0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "
                + "0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "
                + "0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "
                + "0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, "
                + "1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, "
                + "1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, "
                + "1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, "
                + "2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, "
                + "2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, "
                + "2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, "
                + "2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, "
                + "2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, "
                + "3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, "
                + "3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, "
                + "4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, "
                + "4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, "
                + "4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, "
                + "5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, "
                + "5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, "
                + "5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, "
                + "6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, "
                + "6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, "
                + "6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, "
                + "6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, "
                + "6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, "
                + "7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, "
                + "7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, "
                + "7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, "
                + "8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, "
                + "8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, "
                + "8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, "
                + "8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, "
                + "8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, "
                + "8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, "
                + "8, 8, 8, 8, 8, 8, 8, 8, 8, 8]";

        double[][] trainingData = MyMath.toMatrix(strTrainingData);
        int[] classes = MyMath.toIntArr(MyMath.toVector(strClasses));

        long start = System.currentTimeMillis();
        SOMClassifier classifier = new SOMClassifier(trainingData, classes);
        long stop = System.currentTimeMillis();
        double time = ((double)(stop - start)) / 1000.0;
        System.out.println("Time elapsed: " + time + "s");

        assertTrue(true);
    }

}
