/*
 * MyMathTest.java
 * JUnit based test
 *
 * Created on 2007-04-03, 22:59
 */

package iaik.som;

import junit.framework.*;

/**
 * JUnit based test for MyMath.
 *
 * @author Gernot WALZL
 */
public class MyMathTest extends TestCase {

    public MyMathTest(String testName) {
        super(testName);
    }

    public void testAutocovariance() {
        System.out.println("autocovariance");

        double[][] matrix = {{1.0, 2.0},
                {0.5, 1.5},
                {0.3, 1.5},
                {0.2, 0.1}};
        double[][] result = MyMath.autocovariance(matrix);
        double[][] expected = {{0.095, 0.167},
                {0.167, 0.502}};

        assertTrue(MyMath.equalMatrix(expected, result, 3));
    }

    public void testEigenvalues() {
        System.out.println("eigenvalues");

        double[][] squarematrix = {{1.0, 0.5, 2.0},
            {0.5,1.0,0.5},
            {2.0,0.5,1.0}};
        double[] result = MyMath.eigenvalues(squarematrix);
        double[] expected = {-1.0, 0.775, 3.225};

        assertTrue(MyMath.equalVector(expected, result, 3));
    }

    public void testEigenvectors() {
        System.out.println("eigenvectors");

        double[][] squarematrix = {{1.0, 0.5, 2.0},
                {0.5,1.0,0.5},
                {2.0,0.5,1.0}};
        double[][] result = MyMath.eigenvectors(squarematrix);
        double[][] expected = {{-0.707, -0.214, 0.674},
                {0.0, 0.953, 0.303},
                {0.707, -0.214, 0.674}};

        assertTrue(MyMath.equalMatrix(expected, result, 3));
    }

    public void testNormalize() {
        System.out.println("normalize");

        double[] vector = {1.0, 0.7, 5.0};
        double[] result = MyMath.normalize(vector);
        double[] expected = {0.194, 0.136, 0.971};

        assertTrue(MyMath.equalVector(expected, result, 3));
    }

    public void testTranspose() {
        System.out.println("transpose");

        double[][] matrix = {{1.0, 2.0, 3.0},
                {4.0, 5.0, 6.0}};
        double[][] result = MyMath.transpose(matrix);
        double[][] expected = {{1.0, 4.0},
                {2.0, 5.0},
                {3.0, 6.0}};

        assertTrue(MyMath.equalMatrix(expected, result, 3));
    }

    public void testMean() {
        System.out.println("mean");

        double[] vector = {1.0, 4.0, 2.0, 3.0};
        double result = MyMath.mean(vector);

        assertEquals(2.5, result);
    }

    public void testMedian() {
        System.out.println("median");

        double[] vector = {2.0, 100.0, -1.0, 0.5};
        double result = MyMath.median(vector);

        assertEquals(1.25, result);
    }

    public void testMax() {
        System.out.println("max");

        double[] vector = {1.0, 4.0, 2.0, 3.0};
        double result = MyMath.max(vector);

        assertEquals(4.0, result);
    }

    public void testMin() {
        System.out.println("min");

        double[] vector = {1.0, 4.0, 0.5, 3.0};
        double result = MyMath.min(vector);

        assertEquals(0.5, result);
    }

    public void testMaxIndex() {
        System.out.println("maxIndex");

        double[] vector = {1.1, 3.0, 1.1};
        int result = MyMath.maxIndex(vector);

        assertEquals(1, result);
    }

    public void testMinIndex() {
        System.out.println("minIndex");

        double[] vector = {1.1, 3.0, 0.5};
        int result = MyMath.minIndex(vector);

        assertEquals(2, result);
    }

    public void testSum() {
        System.out.println("sum");

        double[] vector = {1.3, 2.1, 1.1};
        double result = MyMath.sum(vector);

        assertEquals(4.5, result);
    }

    public void testMatmult() {
        System.out.println("matmult");

        double[][] matrixA = {{1.0, 2.0},
                {3.0, 4.0},
                {5.0, 6.0}};
        double[][] matrixB = {{1.0, 2.0, 3.0},
                {4.0, 5.0, 6.0}};
        double[][] result = MyMath.matmult(matrixA, matrixB);
        double[][] expected = {{9.0, 12.0, 15.0},
                {19.0, 26.0, 33.0},
                {29.0, 40.0, 51.0}};

        assertTrue(MyMath.equalMatrix(expected, result, 3));
    }

    public void testReshape3d() {
        System.out.println("reshape3d");

        double[][] matrix2d = {{1.0, 2.0, 3.0},
            {4.0, 5.0, 6.0}};
        double[][][] matrix3d = MyMath.reshape3d(matrix2d, 2, 1, 3);

        assertEquals(1.0, matrix3d[0][0][0]);
        assertEquals(5.0, matrix3d[1][0][1]);
        assertEquals(6.0, matrix3d[1][0][2]);
    }

    public void testCopyMatrix() {
        System.out.println("copyMatrix");

        double[][] src = {{0.0, 1.0},
            {2.0, 3.0}};
        double[][] dst = MyMath.copyMatrix(src);

        assertTrue(MyMath.equalMatrix(src, dst, 3));

        dst[1][1] = 10.0;

        assertEquals(3.0, src[1][1]);
        assertEquals(10.0, dst[1][1]);
    }

    public void testCopyVector() {
        System.out.println("copyVector");

        double[] src = {0.5, 1.5, 3.0};
        double[] dst = MyMath.copyVector(src);

        assertTrue(MyMath.equalVector(src, dst, 3));

        dst[1] = 10.0;

        assertEquals(1.5, src[1]);
        assertEquals(10.0, dst[1]);
    }

    public void testRound() {
        System.out.println("round");

        double number = 0.123456789;

        assertEquals(0.12, MyMath.round(number, 2));
    }

    public void testEqualMatrix() {
        System.out.println("equalMatrix");

        double[][] matrixA = {{1.11111, 2.22222},
                {3.33333, 4.44444},
                {5.55555, 6.66666}};
        double[][] matrixB = MyMath.copyMatrix(matrixA);

        assertTrue(MyMath.equalMatrix(matrixA, matrixB, 3));

        matrixA[1][1] = 4.41;

        assertTrue(MyMath.equalMatrix(matrixA, matrixB, 1));
        assertFalse(MyMath.equalMatrix(matrixA, matrixB, 2));
    }

    public void testEqualVector() {
        System.out.println("equalVector");

        double[] vectorA = {1.11111, 2.22222};
        double[] vectorB = MyMath.copyVector(vectorA);

        assertTrue(MyMath.equalVector(vectorA, vectorB, 3));

        vectorA[0] = 1.14;

        assertTrue(MyMath.equalVector(vectorA, vectorB, 1));
        assertFalse(MyMath.equalVector(vectorA, vectorB, 2));
    }

    public void testToVector() {
        System.out.println("testVector");

        String strVec = "[1, 2, 3:5, 1:2:6]";
        double[] result = MyMath.toVector(strVec);
        double[] expected = {1.0, 2.0, 3.0, 4.0, 5.0, 1.0, 3.0, 5.0};

        assertTrue(MyMath.equalVector(expected, result, 3));
    }

    public void testToMatrix() {
        System.out.println("toMatrix");

        String strMat = "[[1,2];\n[3,4]]";
        double[][] result = MyMath.toMatrix(strMat);
        double[][] expected = {{1.0, 2.0}, {3.0, 4.0}};

        assertTrue(MyMath.equalMatrix(expected, result, 3));
    }

}
