/*
 * SOMTreeClassifier.java
 *
 * Created on 2007-06-16, 17:07
 *
 */

package iaik.som;

/**
 *
 * @author Gernot WALZL
 */
public class SOMTreeClassifier {

    protected SOMTreeClassifierNode rootNode;
    protected Object[] labels;

    /** Creates a new instance of SOMTreeClassifier */
    public SOMTreeClassifier(final double[][] trainingData,
            final int[] classes) {
        int numClasses = MyMath.max(classes) + 1;
        labels = new Object[numClasses];
        Object[] subLabels = new Object[numClasses];
        for (int i = 0; i < numClasses; i++) {
            subLabels[i] = i;
        }
        rootNode = new SOMTreeClassifierNode(trainingData, classes, subLabels);
    }


    public int[] classify(final double[][] testData) {
        return rootNode.classify(testData);
    }


    public void setLabels(Object[] labels) {
        this.labels = labels;
    }


    public Object[] classifyLabeled(double[][] testData) {
        int length = testData.length;
        Object[] result = new Object[length];
        int[] classified = rootNode.classify(testData);
        for (int i = 0; i < length; i++) {
            result[i] = labels[classified[i]];
        }
        return result;
    }

}
