from Tkinter import *
from tkFileDialog import asksaveasfilename
from tkFileDialog import askopenfilename
from tkSimpleDialog import askinteger
from hcs.main_functions import *


__author__="Gernot WALZL"
__date__ ="2010-02-24"


class MainFrame:

    def __init__(self, root, mesh, animator=None):
        self.frame = Frame(root)
        self.frame.pack()

        self.mesh = mesh
        self.animator = animator

        self.lf_mesh = LabelFrame(self.frame, text="Mesh")
        self.lf_mesh.grid(row=0, column=0)
        self.b_create = Button(self.lf_mesh, text="Create",
            command=self.create_mesh)
        self.b_create.grid(row=0, column=0, sticky=E+W)
        self.b_open = Button(self.lf_mesh, text="Open",
            command=self.open_mesh)
        self.b_open.grid(row=1, column=0, sticky=E+W)
        self.b_save = Button(self.lf_mesh, text="Save",
            command=self.save_mesh)
        self.b_save.grid(row=2, column=0, sticky=E+W)
        self.b_clear = Button(self.lf_mesh, text="Clear",
            command=self.clear_mesh)
        self.b_clear.grid(row=3, column=0, sticky=E+W)
        self.b_colorize = Button(self.lf_mesh, text="Colorize",
            command=self.colorize_mesh)
        self.b_colorize.grid(row=4, column=0, sticky=E+W)

        self.lf_algorithm = LabelFrame(self.frame, text="Algorithms")
        self.lf_algorithm.grid(row=0, column=1)
        self.b_quick = Button(self.lf_algorithm, text="QuickHull",
            command=self.quick_hull)
        self.b_quick.grid(row=0, column=0, sticky=E+W)
        self.b_split = Button(self.lf_algorithm, text="SplitHull",
            command=self.split_hull)
        self.b_split.grid(row=1, column=0, sticky=E+W)
        self.b_multi = Button(self.lf_algorithm, text="MultiSplit",
            command=self.rand_multi_split)
        self.b_multi.grid(row=2, column=0, sticky=E+W)


    def create_mesh(self):
        if (self.animator):
            self.animator.set_mesh(self.mesh)
        num_nodes = askinteger("Create Mesh", "number of nodes:")
        random_create_nodes(self.mesh, num_nodes)


    def open_mesh(self):
        if (self.animator):
            self.animator.set_mesh(self.mesh)
        filename = askopenfilename(filetypes=
            [('mesh files', '*.mesh'), ('all files', '*.*')])
        self.mesh.load(filename)
        if (self.mesh.description):
            if (len(self.mesh.description) > 0):
                print(self.mesh.description)


    def save_mesh(self):
        if (self.animator):
            self.animator.set_mesh(self.mesh)
        filename = asksaveasfilename(filetypes=
            [('mesh files', '*.mesh'), ('all files', '*.*')])
        self.mesh.save(filename)


    def clear_mesh(self):
        if (self.animator):
            self.animator.set_mesh(self.mesh)
        self.mesh.clear()


    def colorize_mesh(self):
        if (self.animator):
            self.animator.set_mesh(self.mesh)
        num_colors = askinteger("Colorize Mesh", "number of colors:")
        random_set_type(self.mesh, num_colors)


    def quick_hull(self):
        run_quick_hull_demo(self.mesh, self.animator)


    def split_hull(self):
        run_split_hull_demo(self.mesh, self.animator)


    def rand_multi_split(self):
        run_rand_multi_split_demo(self.mesh, self.animator)


