import math
import time
from OpenGL.GL import*
from OpenGL.GLUT import *
from OpenGL.GLU import *
from hcs.ui.opengl.Looker import Looker
from threading import RLock


__author__="Gernot WALZL"
__date__ ="2009-11-05"


windows = dict()
lock_gl = RLock()
glut_started = False


class OpenGLFrame:

    def __init__(self, title, width=640, height=480):
        global windows
        global lock_gl
        self.title = title
        self.width = width
        self.height = height
        self.looker = Looker()
        lock_gl.acquire()
        glutInit()
        glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH)
        glutInitWindowSize(self.width, self.height)
        glutInitWindowPosition(0, 0)
        self.window = glutCreateWindow(title)
        windows.update({self.window: self})
        glutDisplayFunc(OpenGLFrame.draw_gl_scene)
        glutIdleFunc(OpenGLFrame.draw_gl_scene)
        glutReshapeFunc(OpenGLFrame.resize_gl_scene)
        glutKeyboardFunc(OpenGLFrame.key_func)
        glutSpecialFunc(OpenGLFrame.key_func)
        glutKeyboardUpFunc(OpenGLFrame.key_up_func)
        glutSpecialUpFunc(OpenGLFrame.key_up_func)
        glutMouseFunc(OpenGLFrame.mouse_func)
        glutMotionFunc(OpenGLFrame.motion_func)
        self.init_gl()
        lock_gl.release()


    def init_gl(self):
        global lock_gl
        lock_gl.acquire()
        glutSetWindow(self.window)
        glClearColor(0.0, 0.0, 0.0, 0.0)
        glClearDepth(1.0)
        glDepthFunc(GL_LESS)
        glEnable(GL_DEPTH_TEST)
        glShadeModel(GL_SMOOTH)
        self.init_lighting()
        self.init_blending()
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(60.0, float(self.width)/float(self.height), 0.1, 100.0)
        glMatrixMode(GL_MODELVIEW)
        lock_gl.release()


    def init_lighting(self):
        global lock_gl
        lock_gl.acquire()
        light_pos = [10.0, 10.0, 10.0, 0.0]
        light_color_am = [1.0, 1.0, 1.0, 1.0]
        light_color_diff = [1.0, 1.0, 1.0, 1.0]
        light_color_spec = [1.0, 1.0, 1.0, 1.0]
        glShadeModel(GL_SMOOTH)
        glLightfv(GL_LIGHT0, GL_POSITION, light_pos)
        glLightfv(GL_LIGHT0, GL_AMBIENT, light_color_am)
        glLightfv(GL_LIGHT0, GL_DIFFUSE, light_color_diff)
        glLightfv(GL_LIGHT0, GL_SPECULAR, light_color_spec)
        glEnable(GL_LIGHTING)
        glEnable(GL_LIGHT0)
        glEnable(GL_DEPTH_TEST)
        glEnable(GL_COLOR_MATERIAL)
        mat_specular = [0.75, 0.75, 0.75, 0.75]
        mat_shininess = 32.0
        glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular)
        glMaterialf(GL_FRONT, GL_SHININESS, mat_shininess)
        lock_gl.release()


    def init_blending(self):
        global lock_gl
        lock_gl.acquire()
        glEnable(GL_BLEND)
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
        lock_gl.release()


    @staticmethod
    def resize_gl_scene(width, height):
        global windows
        global lock_gl
        if (height == 0):
            height = 1
        lock_gl.acquire()
        this = windows[glutGetWindow()]
        this.width = width
        this.height = height
        glViewport(0, 0, width, height)
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(60.0, float(width)/float(height), 0.1, 100.0)
        glMatrixMode(GL_MODELVIEW)
        lock_gl.release()


    @staticmethod
    def draw_gl_scene():
        global windows
        global lock_gl
        lock_gl.acquire()
        current_window = glutGetWindow()
        this = windows[current_window]
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
	glLoadIdentity()
        looker = this.looker
        gluLookAt(float(looker.eye[0]), float(looker.eye[1]), float(looker.eye[2]),
                float(looker.center[0]), float(looker.center[1]), float(looker.center[2]),
                float(looker.up[0]), float(looker.up[1]), float(looker.up[2]))
        this.draw_gl_content()
        glutSwapBuffers()
        for window in windows:
            if (window != current_window):
                glutSetWindow(window)
                glutPostRedisplay()
        glutSetWindow(current_window)
        lock_gl.release()
        time.sleep(0.01)


    def draw_gl_content(self):
        raise NotImplementedError('to be implemented by inherited class')


    @staticmethod
    def key_func(key, x, y):
        global windows
        global lock_gl
        lock_gl.acquire()
        this = windows[glutGetWindow()]
        this.handle_key_pressed(key, x, y)
        lock_gl.release()


    def handle_key_pressed(self, key, x, y):
        """
        to be implemented by inherited class
        """
        pass


    @staticmethod
    def key_up_func(key, x, y):
        global windows
        global lock_gl
        lock_gl.acquire()
        this = windows[glutGetWindow()]
        this.handle_key_released(key, x, y)
        lock_gl.release()


    def handle_key_released(self, key, x, y):
        """
        to be implemented by inherited class
        """
        pass


    @staticmethod
    def mouse_func(button, state, x, y):
        global windows
        global lock_gl
        lock_gl.acquire()
        this = windows[glutGetWindow()]
        if (state == GLUT_DOWN):
            this.handle_mouse_pressed(button, x, y)
        elif (state == GLUT_UP):
            this.handle_mouse_released(button, x, y)
        lock_gl.release()


    def handle_mouse_pressed(self, button, x, y):
        """
        to be implemented by inherited class
        """
        pass


    def handle_mouse_released(self, button, x, y):
        """
        to be implemented by inherited class
        """
        pass


    @staticmethod
    def motion_func(x, y):
        global windows
        global lock_gl
        lock_gl.acquire()
        this = windows[glutGetWindow()]
        this.handle_motion(x, y)
        lock_gl.release()


    def handle_motion(self, x, y):
        """
        to be implemented by inherited class
        """
        pass


    @staticmethod
    def main_loop():
        global glut_started
        if (not glut_started):
            glutMainLoop()
            glut_started = True


    def close(self):
        global lock_gl
        lock_gl.acquire()
        glutDestroyWindow(self.window)
        lock_gl.release()


    def set_color(self, rgba):
        glColor4f(rgba[0], rgba[1], rgba[2], rgba[3])


    def draw_sphere(self, pos, radius):
        glPushMatrix()
        glTranslatef(pos[0], pos[1], pos[2])
        qobj0 = gluNewQuadric()
        gluQuadricDrawStyle(qobj0, GLU_FILL)
        gluQuadricNormals(qobj0, GLU_SMOOTH)
        gluSphere(qobj0, radius, 8, 8)
        gluDeleteQuadric(qobj0)
        glPopMatrix()


    def draw_pipe(self, startpos, endpos, radius):
        delta = [0.0, 0.0, 0.0]
        height = 0.0
        for i in range(0,len(startpos)):
            delta[i] = endpos[i] - startpos[i]
            height += delta[i]**2
        height = math.sqrt(height)

        glPushMatrix()
        glTranslatef(startpos[0], startpos[1], startpos[2])

        angle_xy = math.atan2(delta[1], delta[0])
        factor_x = -math.sin(angle_xy)
        factor_y = math.cos(angle_xy)
        angle_z = math.acos(delta[2]/height)
        glRotatef(angle_z * (180/math.pi), factor_x, factor_y, 0.0)

        qobj0 = gluNewQuadric()
        gluQuadricDrawStyle(qobj0, GLU_FILL)
        gluQuadricNormals(qobj0, GLU_SMOOTH)
        gluCylinder(qobj0, radius, radius, height, 8, 1)
        gluDeleteQuadric(qobj0)
        glPopMatrix()


    def draw_triangle(self, p1, p2, p3):
        glBegin(GL_TRIANGLES)
        glVertex3f(p1[0], p1[1], p1[2])
        glVertex3f(p2[0], p2[1], p2[2])
        glVertex3f(p3[0], p3[1], p3[2])
        glEnd()


    def draw_arrow(self, position, direction):
        length = 0.0
        for i in range(0,len(direction)):
            length += direction[i]**2
        length = math.sqrt(length)

        glPushMatrix()
        glTranslatef(position[0], position[1], position[2])

        angle_xy = math.atan2(direction[1], direction[0])
        factor_x = -math.sin(angle_xy)
        factor_y = math.cos(angle_xy)
        angle_z = math.acos(direction[2]/length)
        glRotatef(angle_z * (180/math.pi), factor_x, factor_y, 0.0)

        qobj0 = gluNewQuadric()
        gluQuadricDrawStyle(qobj0, GLU_FILL)
        gluQuadricNormals(qobj0, GLU_SMOOTH)
        gluCylinder(qobj0, length/12.0, length/12.0, length*2.0/3.0, 8, 1)
        gluDeleteQuadric(qobj0)

        glTranslatef(0.0, 0.0, length*2.0/3.0)

        qobj0 = gluNewQuadric()
        gluQuadricDrawStyle(qobj0, GLU_FILL)
        gluQuadricNormals(qobj0, GLU_SMOOTH)
        gluCylinder(qobj0, length/6.0, 0.0, length/3.0, 8, 1)
        gluDeleteQuadric(qobj0)

        glPopMatrix()


    def draw_text(self, text):
        size = 0.00005
        self.set_color([1.0, 1.0, 1.0, 1.0])
        glPushMatrix()
        glLoadIdentity()
        glTranslatef(-0.075, 0.05, -0.1)
        glScalef(size, size, size)
        glPushMatrix()
        for c in text:
            if (c == '\n'):
                glPopMatrix()
                glPushMatrix()
                glTranslatef(0.0, -150.0, 0.0)
                continue
            glutStrokeCharacter(GLUT_STROKE_ROMAN, ord(c))
        glPopMatrix()
        glPopMatrix()


