__author__="Gernot WALZL"
__date__ ="2009-11-05"

class MouseAdapter:

    def __init__(self, opengl_frame):
        self.looker = opengl_frame.looker
        self.opengl_frame = opengl_frame

        self.b_look = 1
        self.b_rotate = 0
        self.b_pan = 2
        self.b_forward = 3
        self.b_backpedal = 4

        self.mouse_look = False
        self.mouse_rotate = False
        self.mouse_pan = False

        self.look_sensitivity = 0.01
        self.rotate_sensitivity = 0.01
        self.pan_sensitivity = 0.01

        self.prev_pos = [0.0, 0.0]


    def mouse_pressed(self, button, x, y):
        self.prev_pos[0] = x
        self.prev_pos[1] = y
        if (button == self.b_look): self.mouse_look = True
        if (button == self.b_rotate): self.mouse_rotate = True
        if (button == self.b_pan): self.mouse_pan = True
        if (button == self.b_forward): self.looker.forward()
        if (button == self.b_backpedal): self.looker.backpedal()

    def mouse_released(self, button):
        if (button == self.b_look): self.mouse_look = False
        if (button == self.b_rotate): self.mouse_rotate = False
        if (button == self.b_pan): self.mouse_pan = False

    def mouse_dragged(self, x, y):
        delta = [0.0, 0.0]
        delta[0] = x - self.prev_pos[0]
        delta[1] = y - self.prev_pos[1]
        self.prev_pos[0] = x
        self.prev_pos[1] = y
        if (self.mouse_look):
            self.looker.look_lr(delta[0] * self.look_sensitivity)
            self.looker.look_ud(-delta[1] * self.look_sensitivity)
        if (self.mouse_rotate):
            self.looker.rotate_world_lr(delta[0] * self.rotate_sensitivity)
            self.looker.rotate_world_ud(-delta[1] * self.rotate_sensitivity)
        if (self.mouse_pan):
            self.looker.strafe_lr(-delta[0] * self.pan_sensitivity)
            self.looker.strafe_ud(delta[1] * self.pan_sensitivity)

