from threading import Thread
from hcs.ui.opengl.OpenGLFrame import OpenGLFrame
from hcs.ui.opengl.KeyboardAdapter import KeyboardAdapter
from hcs.ui.opengl.MouseAdapter import MouseAdapter


__author__="Gernot WALZL"
__date__ ="2009-11-06"


class MainOpenGLThread(Thread):
    """
    This thread should only be started once.
    If you need more frames than one frame,
    import a thread that creates more frames.
    """

    def __init__(self, mesh, animator=None):
        Thread.__init__(self)
        self.mesh = mesh
        self.animator = animator

    def run(self):
        MainOpenGLFrame("Hereditary Convex Structures",
            self.mesh, self.animator)
        OpenGLFrame.main_loop()



class MainOpenGLFrame(OpenGLFrame):

    def __init__(self, title, mesh, animator=None):
        OpenGLFrame.__init__(self, title)
        self.mesh = mesh
        self.animator = animator
        self.keyadapter = KeyboardAdapter(self)
        self.mouseadapter = MouseAdapter(self)
        self.colors = [[0.5, 0.5, 0.5, 1.0],
                [1.0, 0.0, 0.0, 1.0],
                [0.0, 0.0, 1.0, 1.0],
                [0.0, 1.0, 0.0, 1.0],
                [0.0, 1.0, 1.0, 1.0],
                [1.0, 1.0, 0.0, 1.0],
                [1.0, 0.0, 1.0, 1.0]]
        self.color_highlight = [1.0, 1.0, 0.0, 1.0]


    def draw_gl_content(self):
        self.set_color([1.0, 0.0, 0.0, 1.0])
        self.draw_arrow([0.0, 0.0, 0.0], [0.1, 0.0, 0.0])
        self.set_color([0.0, 1.0, 0.0, 1.0])
        self.draw_arrow([0.0, 0.0, 0.0], [0.0, 0.1, 0.0])
        self.set_color([0.0, 0.0, 1.0, 1.0])
        self.draw_arrow([0.0, 0.0, 0.0], [0.0, 0.0, 0.1])

        radius_sphere = 0.02
        radius_pipe = 0.01

        if (self.animator):
            self.animator.lock.acquire()
            if (self.animator._mesh):
                self.mesh = self.animator._mesh
                self.animator._mesh = None
            self.animator.lock.release()

        self.mesh.lock.acquire()
        for node in self.mesh.nodes:
            if (node.highlight):
                self.set_color(self.color_highlight)
            else:
                self.set_color(self.colors[node.get_type()])
            self.draw_sphere(node.position, radius_sphere)
        self.mesh.lock.release()
        self.mesh.lock.acquire()
        for edge in self.mesh.edges:
            if (edge.highlight):
                self.set_color(self.color_highlight)
            else:
                self.set_color(self.colors[edge.get_type()])
            self.draw_pipe(edge.node_a.position, edge.node_b.position,
                    radius_pipe)
        self.mesh.lock.release()
        self.mesh.lock.acquire()
        for face in self.mesh.faces:
            if (face.highlight):
                self.set_color([1.0, 1.0, 0.0, 0.5])
            else:
                self.set_color([0.5, 0.5, 0.5, 0.5])
            self.draw_triangle(face.node_a.position,
                    face.node_b.position,
                    face.node_c.position)
            pos = [0.0, 0.0, 0.0]
            for i in range(0, 3):
                pos[i] += face.node_a.position[i]
                pos[i] += face.node_b.position[i]
                pos[i] += face.node_c.position[i]
                pos[i] /= 3.0
            normal = face.normal()
            for i in range(0, 3):
                normal[i] *= 0.1
            self.draw_arrow(pos, normal)
        self.mesh.lock.release()

        if (self.animator):
            self.animator.lock.acquire()
            if (self.animator._text):
                self.draw_text(self.animator._text)
            self.animator.lock.release()


    def handle_key_pressed(self, key, x, y):
        self.keyadapter.key_pressed(key)


    def handle_key_released(self, key, x, y):
        self.keyadapter.key_released(key)


    def handle_mouse_pressed(self, button, x, y):
        self.mouseadapter.mouse_pressed(button, x, y)


    def handle_mouse_released(self, button, x, y):
        self.mouseadapter.mouse_released(button)


    def handle_motion(self, x, y):
        self.mouseadapter.mouse_dragged(x, y)

