from threading import Thread
import time

__author__="Gernot WALZL"
__date__ ="2009-11-05"


class FixedRateTimer(Thread):

    def __init__(self, keyadapt):
        self.keyadapt = keyadapt
        Thread.__init__(self)

    def run(self):
        while True:
            if (self.keyadapt.move_forward): self.keyadapt.looker.forward()
            if (self.keyadapt.move_backpedal): self.keyadapt.looker.backpedal()
            if (self.keyadapt.move_left): self.keyadapt.looker.strafe_left()
            if (self.keyadapt.move_right): self.keyadapt.looker.strafe_right()
            if (self.keyadapt.move_up): self.keyadapt.looker.strafe_up()
            if (self.keyadapt.move_down): self.keyadapt.looker.strafe_down()
            if (self.keyadapt.look_left): self.keyadapt.looker.look_left()
            if (self.keyadapt.look_right): self.keyadapt.looker.look_right()
            if (self.keyadapt.look_up): self.keyadapt.looker.look_up()
            if (self.keyadapt.look_down): self.keyadapt.looker.look_down()
            time.sleep(0.01)



class KeyboardAdapter:

    def __init__(self, opengl_frame):
        self.looker = opengl_frame.looker
        self.animator = opengl_frame.animator
        self.opengl_frame = opengl_frame

        self.k_move_forward = 'w'
        self.k_move_backpedal = 's'
        self.k_move_left = 'a'
        self.k_move_right = 'd'
        self.k_move_up = 'e'
        self.k_move_down = 'c'
        self.k_look_left = 100
        self.k_look_right = 102
        self.k_look_up = 101
        self.k_look_down = 103
        self.k_reset = chr(8)  # BACKSPACE
        self.k_pause = 'p'
        self.k_step = ' '
        self.k_skip = '\033'   # ESCAPE

        self.move_forward = False
        self.move_backpedal = False
        self.move_left = False
        self.move_right = False
        self.move_up = False
        self.move_down = False
        self.look_left = False
        self.look_right = False
        self.look_up = False
        self.look_down = False

        self.timer = FixedRateTimer(self)
        self.timer.start()


    def key_pressed(self, key):
        if (key == self.k_move_forward): self.move_forward = True
        if (key == self.k_move_backpedal): self.move_backpedal = True
        if (key == self.k_move_left): self.move_left = True
        if (key == self.k_move_right): self.move_right = True
        if (key == self.k_move_up): self.move_up = True
        if (key == self.k_move_down): self.move_down = True
        if (key == self.k_look_left): self.look_left = True
        if (key == self.k_look_right): self.look_right = True
        if (key == self.k_look_up): self.look_up = True
        if (key == self.k_look_down): self.look_down = True
        if (key == self.k_reset): self.looker.reset()
        if (key == self.k_pause): self.animator.toggle_pause()
        if (key == self.k_step): self.animator.next_step()
        if (key == self.k_skip): self.animator.skip()


    def key_released(self, key):
        if (key == self.k_move_forward): self.move_forward = False
        if (key == self.k_move_backpedal): self.move_backpedal = False
        if (key == self.k_move_left): self.move_left = False
        if (key == self.k_move_right): self.move_right = False
        if (key == self.k_move_up): self.move_up = False
        if (key == self.k_move_down): self.move_down = False
        if (key == self.k_look_left): self.look_left = False
        if (key == self.k_look_right): self.look_right = False
        if (key == self.k_look_up): self.look_up = False
        if (key == self.k_look_down): self.look_down = False

