import time
from threading import RLock

__author__="Gernot WALZL"
__date__ ="2009-12-07"

class Animator:

    def __init__(self, time=1.0):
        self.lock = RLock()
        self.lock.acquire()
        self._time = time
        self._time_before = time
        self._mesh = None
        self._text = None
        self.pause = False
        self.step = False
        self.lock.release()

    def set_time(self, time):
        self.lock.acquire()
        self._time = time
        self._time_before = time
        self.lock.release()

    def set_mesh(self, mesh):
        self.lock.acquire()
        self._mesh = mesh
        self.lock.release()

    def set_text(self, text):
        self.lock.acquire()
        self._text = text
        self.lock.release()

    def toggle_pause(self):
        self.lock.acquire()
        self.pause = not self.pause
        self.lock.release()

    def next_step(self):
        self.step = True

    def skip(self):
        self._time_before = self._time
        self._time = 0.0
        self.pause = False

    def halt_skip(self):
        self._time = self._time_before

    def wait(self):
        secs = 0.01
        current = 0.0
        while (self.pause or current <= self._time):
            if (self.step):
                self.step = False
                break
            time.sleep(secs)
            current += secs

