#import math
from hcs.data.LinkedList import LinkedList


__author__="Gernot WALZL"
__date__ ="2010-03-01"



class NodeData:

    def __init__(self):
        self.origin = None



class Node:
    """
    Vertex, Point
    """

    exponent = -1

    def __init__(self, position=[0.0, 0.0, 0.0], type=0):
        self.position = position
        self.edges = LinkedList()
        self.faces = LinkedList()
        self.mesh = None
        self.mesh_list_element = None
        self.type = type
        self.highlight = False
        self.data = None

    def __str__(self):
        result = 'Node(['
        result += '{0:.3f}'.format(round(self.position[0], 3))
        result += ', '
        result += '{0:.3f}'.format(round(self.position[1], 3))
        result += ', '
        result += '{0:.3f}'.format(round(self.position[2], 3))
        result += ']'
        if (self.type != 0):
            result += ', '
            result += str(self.type)
        result += ')'
        return result

    @staticmethod
    def from_str(str):
        start = str.index('(')+1
        end = str.rindex(')')
        strparams = str[start:end].strip()
        end = strparams.index(']')
        strpos = strparams[1:end].strip()
        pos = strpos.split(',')
        position = [0.0, 0.0, 0.0]
        for i in range(0, 3):
            position[i] = float(pos[i].strip())
        rest = strparams[end+1:].strip()
        type = 0
        if (len(rest) > 0):
            strtype = rest[1:].strip()
            type = int(strtype)
        return Node(position, type)

    def get_type(self):
        return self.type

    #def get_exponent(self):
    #    exponent = None
    #    for i in range(0, 3):
    #        if (self.position[i] != 0.0):
    #            exponent_curr = int(math.floor(
    #                math.log10(abs(self.position[i]))))
    #            if (exponent is None):
    #                exponent = exponent_curr
    #            elif (exponent < exponent_curr):
    #                exponent = exponent_curr
    #    if (exponent is None):
    #        exponent = -1
    #    return exponent

    def __hash__(self):
        """
        Will return mantissa of flaoting point values of position in base 10.
        The hash value is an integer and will look like "xxx yyy zzz"
        for positive coordinates.
        """
        result = 0
        exponent = self.exponent
        for i in range(0, 3):
            if (i > 0):
                result *= 10**3
            result += int(self.position[i] * 10**(2-exponent))
        return result

    def __eq__(self, other):
        if (other is None):
            return False
        exponent = self.exponent
        epsilon = 10**(exponent-2)
        for i in xrange(0, 3):
            if (self.position[i] - epsilon > other.position[i] or
                    other.position[i] > self.position[i] + epsilon):
                return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)

    def clone(self):
        return self.__class__(self.position, self.type)


