import math
from hcs.data.Node import Node


__author__="Gernot WALZL"
__date__ ="2010-03-01"



class FaceData:

    def __init__(self):
        self.origin = None



class Face:
    """
    Facet, Triangle
    """

    def __init__(self, node_a, node_b, node_c,
            edge_a=None, edge_b=None, edge_c=None):
        self.node_a = node_a
        self.node_b = node_b
        self.node_c = node_c
        self.edge_a = edge_a
        self.edge_b = edge_b
        self.edge_c = edge_c
        self.mesh = None
        self.mesh_list_element = None
        self.node_a_list_element = None
        self.node_b_list_element = None
        self.node_c_list_element = None
        self.highlight = False
        self.data = None

    def __str__(self):
        result = 'Face('
        if (self.mesh):
            result += 'nodes['
            result += str(self.mesh.nodes.find_index(self.node_a))
            result += '], nodes['
            result += str(self.mesh.nodes.find_index(self.node_b))
            result += '], nodes['
            result += str(self.mesh.nodes.find_index(self.node_c))
            result += ']'
        else:
            result += str(self.node_a)
            result += ', '
            result += str(self.node_b)
            result += ', '
            result += str(self.node_c)
        result += ')'
        return result

    @staticmethod
    def from_str(str, mesh=None):
        start = str.index('(') + 1
        end = str.rindex(')')
        strparams = str[start:end]
        if (mesh):
            start = 0
            for i in range(0, 3):
                start = strparams.index('[', start) + 1
                end = strparams.index(']', start)
                index = int(strparams[start:end])
                if (i == 0):
                    node_a = mesh.nodes[index]
                elif (i == 1):
                    node_b = mesh.nodes[index]
                elif (i == 2):
                    node_c = mesh.nodes[index]
                start = end
        else:
            start = 0
            for i in range(0, 3):
                start = strparams.index('Node(', start)
                end = strparams.index(')', start) + 1
                if (i == 0):
                    node_a = Node.from_str(strparams[start:end])
                elif (i == 1):
                    node_b = Node.from_str(strparams[start:end])
                elif (i == 2):
                    node_c = Node.from_str(strparams[start:end])
                start = end
        return Face(node_a, node_b, node_c)

    def swap_normal(self):
        node = self.node_a
        element = self.node_a_list_element
        edge = self.edge_a
        self.node_a = self.node_b
        self.node_a_list_element = self.node_b_list_element
        self.edge_a = self.edge_b
        self.node_b = node
        self.node_b_list_element = element
        self.edge_b = edge

    def get_type(self):
        result = 0
        if (self.node_a.type == self.node_b.type and
                self.node_b.type == self.node_c.type):
            result = self.node_a.type
        return result

    @staticmethod
    def cross_prod(a=[0.0, 0.0, 0.0], b=[0.0, 0.0, 0.0]):
        result = [0.0, 0.0, 0.0]
        result[0] = a[1]*b[2] - a[2]*b[1]
        result[1] = a[2]*b[0] - a[0]*b[2]
        result[2] = a[0]*b[1] - a[1]*b[0]
        return result

    def normal(self):
        a = [0.0, 0.0, 0.0]
        b = [0.0, 0.0, 0.0]
        for i in range(0, 3):
            a[i] = self.node_a.position[i] - self.node_c.position[i]
            b[i] = self.node_b.position[i] - self.node_c.position[i]
        n = Face.cross_prod(a, b)
        length = 0.0
        for i in range(0, 3):
            length += n[i]**2
        length = math.sqrt(length)
        for i in range(0, 3):
            n[i] /= length
        return n

    def __hash__(self):
        result = 11;
        hashes = [hash(self.node_a), hash(self.node_b), hash(self.node_c)]
        hashes.sort()
        for h in hashes:
            result = 3 * result + h
        return result

    def __eq__(self, other):
        if (other is None):
            return False
        if (self.node_a != other.node_a and
                self.node_a != other.node_b and
                self.node_a != other.node_c):
            return False
        if (self.node_b != other.node_a and
                self.node_b != other.node_b and
                self.node_b != other.node_c):
            return False
        if (self.node_c != other.node_a and
                self.node_c != other.node_b and
                self.node_c != other.node_c):
            return False
        normal_self = self.normal()
        normal_other = other.normal()
        d = 0.0
        for i in range(0, 3):
            d += (normal_self[i] - normal_other[i])**2
        if (d > 0.001):
            return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)


