from hcs.data.Node import Node


__author__="Gernot WALZL"
__date__ ="2010-03-01"



class EdgeData:

    def __init__(self):
        self.origin = None



class Edge:

    def __init__(self, node_a, node_b, face_l=None, face_r=None):
        self.node_a = node_a
        self.node_b = node_b
        self.face_l = face_l
        self.face_r = face_r
        self.mesh = None
        self.mesh_list_element = None
        self.node_a_list_element = None
        self.node_b_list_element = None
        self.highlight = False
        self.data = None

    def __str__(self):
        result = 'Edge('
        if (self.mesh):
            result += 'nodes['
            result += str(self.mesh.nodes.find_index(self.node_a))
            result += '], nodes['
            result += str(self.mesh.nodes.find_index(self.node_b))
            result += ']'
        else:
            result += str(self.node_a)
            result += ', '
            result += str(self.node_b)
        result += ')'
        return result

    @staticmethod
    def from_str(str, mesh=None):
        start = str.index('(') + 1
        end = str.rindex(')')
        strparams = str[start:end]
        if (mesh):
            start = 0
            for i in range(0, 2):
                start = strparams.index('[', start) + 1
                end = strparams.index(']', start)
                index = int(strparams[start:end])
                if (i == 0):
                    node_a = mesh.nodes[index]
                elif (i == 1):
                    node_b = mesh.nodes[index]
                start = end
        else:
            start = 0
            for i in range(0, 2):
                start = strparams.index('Node(', start)
                end = strparams.index(')', start) + 1
                if (i == 0):
                    node_a = Node.from_str(strparams[start:end])
                elif (i == 1):
                    node_b = Node.from_str(strparams[start:end])
                start = end
        return Edge(node_a, node_b)

    def swap_nodes(self):
        node = self.node_a
        element = self.node_a_list_element
        self.node_a = self.node_b
        self.node_a_list_element = self.node_b_list_element
        self.node_b = node
        self.node_b_list_element = element

    def get_type(self):
        result = 0
        if (self.node_a.type == self.node_b.type):
            result = self.node_a.type
        return result

    def __hash__(self):
        result = 7;
        hashes = [hash(self.node_a), hash(self.node_b)]
        hashes.sort()
        for h in hashes:
            result = 5 * result + h
        return result

    def __eq__(self, other):
        if (other is None):
            return False
        if (self.node_a != other.node_a and self.node_a != other.node_b):
            return False
        if (self.node_b != other.node_a and self.node_b != other.node_b):
            return False
        return True

    def __ne__(self, other):
        return not self.__eq__(other)


