#!/usr/bin/env python

import time
from Tkinter import Tk
from hcs.ui.tk.MainFrame import MainFrame
from hcs.ui.opengl.MainOpenGLFrame import MainOpenGLThread
from hcs.ui.opengl.Animator import Animator
from hcs.data.MyMesh import MyMesh
# the following imports are necessary for cProfile
from hcs.algo.QuickHull import quick_hull
from hcs.algo.SplitHull import split_hull
from hcs.algo.RandMultiSplit import rand_multi_split


__author__="Gernot WALZL"
__date__ ="2009-11-05"


if __name__=='__main__':
    print('Hello to Hereditary Convex Structures')
    print('http://www.cs.princeton.edu/~chazelle/pubs/socg09.pdf')
    print('Implemented by Gernot WALZL')
    print('')
    mesh = MyMesh()
    animator = Animator()
    t_ogl = MainOpenGLThread(mesh, animator)
    t_ogl.start()
    time.sleep(0.1)
    root = Tk()
    root.title('HCS')
    root.resizable(0,0)
    app = MainFrame(root, mesh, animator)
    root.mainloop()

